package gov.va.med.mhv.usermgmt.web.controller;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.service.AccountValidatorService;
import gov.va.med.mhv.usermgmt.service.UserMgmtService;

import java.io.Serializable;

import javax.annotation.Resource;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleDisplay;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journalcontent.util.JournalContentUtil;

@ManagedBean (name="mhvTandCController")
@Component
@Scope("request")
public class MhvTandCController implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = -4870638223245108582L;

	private String content;

	//JOURNALARTICLE.URLTITLE and STATUS should be 1
	public static String OLD_ARTICLE_NAME="prev-terms-conditions";
	public static String NEW_ARTICLE_NAME="terms-conditions";

	@Resource
	private UserMgmtService userMgmtServiceProxy;

	public void findTermsAndConditionArticle() {

		String articleName = null;
		PortletRequest portletRequest = (PortletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();  

		ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute(WebKeys.THEME_DISPLAY);
		
		//themeDisplay.getScopeGroupId()
		JournalArticle journalArticle = null;
		try {

			PortletSession session = portletRequest.getPortletSession();
			String patientStr = null;

			if(session != null)
				patientStr =  (String)session.getAttribute("LIFERAY_SHARED_userprofiledto", PortletSession.APPLICATION_SCOPE);

			if(patientStr != null) {

				try {
					String jsonObjectStr = userMgmtServiceProxy.hasAcceptedLatestTermsConditions();
					JSONObject jObj = new JSONObject(jsonObjectStr); 
					String hasLatest = jObj.getString("required");
					boolean required = Boolean.parseBoolean(hasLatest);
					if(required) {
						//Show OLD Terms and Conditions
						articleName = OLD_ARTICLE_NAME;
					}
					else {
						//Show latest Terms and Conditions
						articleName = NEW_ARTICLE_NAME;
					}

				} catch (MHVException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (JSONException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

			}
			else {
				//Show latest Terms and Conditions
				articleName = NEW_ARTICLE_NAME;
			}

			// Pull the Terms and Condition now
			journalArticle = JournalArticleLocalServiceUtil.getArticleByUrlTitle(themeDisplay.getScopeGroupId(), articleName); //getArticleByUrlTitle
			//journalArticle = JournalArticleLocalServiceUtil. .getArticle(25286, "61967"); //.getArticleByUrlTitle(25286, articleName);

			String articleId = journalArticle.getArticleId();
			JournalArticleDisplay articleDisplay = JournalContentUtil.getDisplay(themeDisplay.getScopeGroupId(), articleId,"", "", themeDisplay);
			content = articleDisplay.getContent();
		} catch (PortalException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SystemException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}		
	public String getContent() {
		//	if(content ==null)
		findTermsAndConditionArticle();
		//	System.out.println("CONTENT: " + content);
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

}
